//Source file: H:\src\Alkindi\Services\Client\ClusterMgrClient.java

/* Copyright (C) 2000-2001 Alkindi, Inc. */

package Alkindi.Services.Client;

import Alkindi.Data.*;
import java.util.*;
import Alkindi.Services.BeanIface.IClusterManagerBean;
import Alkindi.Services.AlkExcept;

/* 
$Header: ClusterMgrClient.java, 2, 4/25/01 4:41:04 PM, Schwartz, Joe$
$Log: 
 2    Alkindi Development1.1         4/25/01 4:41:04 PM   Schwartz, Joe   Added
      CRs to usage() message.
 1    Alkindi Development1.0         4/23/01 10:21:56 AM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Client class for the ClusterManager. Allows for simple scripts to perform clustering operations.
 */
public class ClusterMgrClient 
{
	private IClusterManagerBean cm = null;
	private static ClusterMgrClient This = null;
	
	protected void finalize() throws Throwable 
	{
		try {
			cm.remove();
		}
		catch(Exception e) {
		}
		super.finalize();
	}
	
	/**
	 * @roseuid 3AE43B6C031C
	 */
	public ClusterMgrClient() throws AlkExcept 
	{
		try {
			cm = BeanUtil.getClusterMgr();
			System.out.println("Created Cluster Manager.");
		}
		catch (Exception e)  {
			throw new AlkExcept(e.toString(), 8000);
		}
	}
	
	/**
	 * @roseuid 3AE438CC0399
	 */
	public void clusterUser(final int uid) throws AlkExcept 
	{
		System.out.println("Clustering user " + uid);
		SystemUser user = new SystemUser(uid);
		try {
			cm.clusterUser(user);	
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
	}
	
	/**
	 * @roseuid 3AE4356A029F
	 */
	public void initClusters() throws AlkExcept 
	{
		System.out.println("Starting intializeClusters() at " + Calendar.getInstance().getTime());
		try {
			cm.initializeClusters();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
		System.out.println("Finished at " + Calendar.getInstance().getTime());
	}
	
	/**
	 * @roseuid 3AE4343C008C
	 */
	public static void main(java.lang.String[] args) 
	{
		try {
			This = new ClusterMgrClient();
			if (args.length == 0) {
//			if (args[0].length() == 0) {
				usage();
			}
			else if (args[0].compareTo("init") == 0) {
				This.initClusters();
			}
			else if (args[0].compareTo("regen") == 0 ) {
				This.regenClusters();
			}
			else if (args[0].compareTo("stats") == 0) {
				This.recalcStats();
			}
			else if (args[0].compareTo("user") == 0) {
				if (args.length < 2) {
					usage();
				}
				int uid = Integer.parseInt(args[1]);
				This.clusterUser(uid);
			}

			else {
				usage();
			}
		}
		catch (Exception e) {
			System.out.println("Caught exception: " + e.toString());
			e.printStackTrace();

		}
	}
	
	/**
	 * @roseuid 3AE4359D02FD
	 */
	public void recalcStats() throws AlkExcept 
	{
		// recalcStats
		//
		System.out.println("Starting recalcStats() at " + Calendar.getInstance().getTime());
		try {
			cm.recalcStats();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
		System.out.println("Finished at " + Calendar.getInstance().getTime());
	}
	
	/**
	 * @roseuid 3AE4357F0119
	 */
	public void regenClusters() throws AlkExcept 
	{
		System.out.println("Starting regenerateClusters() at " + Calendar.getInstance().getTime());
		try {
			cm.regenerateClusters();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
		System.out.println("Finished at " + Calendar.getInstance().getTime());
	}
	
	/**
	 * Prints out a small help message.
	 * @roseuid 3AE435560148
	 */
	public static void usage() 
	{
		StringBuffer msgBuf = new StringBuffer();
		msgBuf.append("Usage: call with a one of the following:\n");
		msgBuf.append("\tinit   	- intialize clusters\n");
		msgBuf.append("\tregen  	- regenerate clusters\n");
		msgBuf.append("\tstats  	- recalc cluster stats\n");
		msgBuf.append("\tuser [uid]- cluster the specified user\n");
		System.out.println(msgBuf);
		System.exit(1);
	}
}
